class Cyberdemon_s : Cyberdemon replaces Cyberdemon
{	
int stomprange;

property stompdistance : stomprange;

default
{
	meleerange                 42; /* 67.8822509939, max range is ~ 96 */
	Cyberdemon_s.stompdistance 32;
	meleethreshold             121;
	speed                      16;
	mass                       2000;
	damagetype                 "stomp";
	/* +QUICKTORETALIATE */
}

action void
A_StompThings(int damagerange, int quakerange)
{
	BlockThingsIterator it = BlockThingsIterator.Create(self, damagerange);

	A_StartSound("stomp/boom", CHAN_AUTO);
	A_Quake(2, 20, 0, quakerange, "");
	
	while (it.Next())
	{
		Actor t = it.thing;
		
		if (t.bSolid && !(t is "Cyberdemon"))
		{
			int done = t.DamageMobj(self, self, 100, damagetype);
			
			t.A_Stop();
			
			if (done > 0 && t.health <= 0)
			{
				//meleerange *= 0.75;
				//meleethreshold *= 2;
				// SeeSound  = "";
				
			}
	}
	}
}

states
{
melee:
stomp:
	CYMA A 4  A_FaceTarget();
	CYMA A 4  A_Recoil(-random(1, 2));
	---- A 0  A_Recoil(-random(1, 2));
	CYMA B 16 A_StompThings(stomprange, meleethreshold*4);
	goto see;
}
}
